/**********************************************************************
*
* autolaunch start.c -- Version 3.0
*
* Copyright (c)
* Apple Computer, Inc.  1988-1990
* All Rights Reserved.
*
* Written by Eric Soldan.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code needed to start (and quit) autolaunch.
*
**********************************************************************/

#include <types.h>
#include <quickdraw.h>
#include <loader.h>
#include <locator.h>
#include <memory.h>
#include <gsos.h>
#include <sane.h>

#include "autolaunch.h"

void	doFmdStartUp();
void	doFmdShutDown();

#ifdef __fmdTool__
static InitialLoadOutputRec		fmdInfo;
#endif

/*********************************************************************/

main()
{
	Handle			saneHandle;
	Ref				initRef;	/* This holds the reference to the startstop record */
	unsigned int	oldPathLen;

	static struct PrefixRecGS quitPrefix0 = {
		2,
		0,
		(GSString255Ptr)launch.targetPath
	};
	static struct PrefixRecGS quitPrefix8 = {
		2,
		8,
		(GSString255Ptr)launch.targetPath
	};

	static struct QuitRecGS quit = {
		2,
		NULL,
		onStack+restartable
	};

	TLStartUp();
	MMStartUp();
	initPtrCheck(_ownerid);

	initRef = StartUpTools(_ownerid, refIsResource, 0x0001L);
		/* Start up the tools using the new toolbox call */

	if (!_toolErr) doFmdStartUp();		/* Start up fakeModalDialog.   */
	if (!_toolErr) initGlobals();		/* Initialize our globals.	   */
	if (!_toolErr) setupMenus();		/* Set up menus.			   */
	if (!_toolErr) InitCursor();		/* Make cursor show ready.	   */
	if (!_toolErr) mainEvent();			/* Use application.			   */

	doFmdShutDown();
	
	ShutDownTools(refIsHandle, initRef);
		/* Let the toolbox shut down the tools. */

	closePtrCheck();
	MMShutDown(_ownerid);
	TLShutDown();

	if (quitFlag == 2) {
		saneHandle = FindHandle(GetWAP(0,10));
		SANEShutDown();
		DisposeHandle(saneHandle);

		oldPathLen = truncFileName(launch.targetPath);
		SetPrefixGS(&quitPrefix0);
		SetPrefixGS(&quitPrefix8);
		*(int *)launch.targetPath = oldPathLen;

		quit.pathname = (GSString255Ptr)launch.targetPath;
		PurgeAll(0x1000);	/* So restartable applications can   */
							/* run a second time after a change. */
		QuitGS(&quit);
	}
}

/*********************************************************************/

void	doFmdStartUp()
{
	unsigned int	tempID, err;
	static char		fmdName[] = "\p9:FakeModalTool";

#ifdef __fmdTool__

	fmdInfo.userID = 0;				/* In case we fail.				   */

	tempID = GetUserID(fmdName);	/* Get our own ID for the toolset. */

	if (!_toolErr) fmdInfo = Restart(tempID);
	if (_toolErr)  fmdInfo = InitialLoad(0x1000, fmdName, 0);
	if (err = _toolErr) {
		InitCursor();
		TLMountVolume(40, 32, "\pYou need fakeModalTool in same",
			"\pfolder as autolaunch.", "\pAgain", "\pCome");
		_toolErr = err;
	}
	else SetTSPtr(userTool, fmdToolNum, fmdInfo.startAddr);

#endif

	if (!_toolErr) fmdStartUp();
}

/*********************************************************************/

void	doFmdShutDown()
{
	fmdShutDown();

#ifdef __fmdTool__

	if (fmdInfo.userID)
		UserShutDown(fmdInfo.userID, 0x4000);	/* restartable from memory */

#endif

}

